/*
 ͻ
                                                                           
                      Copyright (c) 1996 Aldo Ferraro                      
                            All Rights Reserved                            
                                                                           
 Ķ
                                                                           
   Source File :  PCX.CPP                                                  
                                                                           
   Description :  Load & Decompress 256-Colour PCX Image                   
                                                                           
   Compiler    :  Borland C++ version 3.1                                  
                                                                           
   Project List:  PCX.CPP, BAILOUT.CPP                                     
                                                                           
   Author Name :  Aldo Ferraro                                             
                                                                           
   Address     :  19 Munro Close, Swindon, Wiltshire, England SN3 1BF      
                                                                           
   Developed on:  10 June 1996 - version 1.00.                             
                                                                           
 ͼ

 ͻ
                      Preprocessor #include Directives                     
 ͼ
*/

#include "pcx.h"

/*
 ͻ
                               Load PCX File                               
 Ķ
                                                                           
   Description :  Load PCX data from requested file into PCX class.        
                                                                           
   Prototype   :  void pcx::load_pcx_file(char far *file, pcx_class *pcx)  
                                                                           
 ͼ
*/

void pcx::load_pcx_file(char far *filename, pcx_class *pcx)
{
  if ((input_file = fopen(filename,"rb")) == NULL) {
//    bail_out("File Load Failed", __LINE__);
    printf("File Load Failed\n");
    exit(1);
  }

  // get PCX file header
  fread((char *)&pcx->header, sizeof(pcx_header), 1, input_file);

  // call function to decompress PCX image and store it in buffer
  load_image(input_file, pcx);

  // call function to decompress PCX palette and store it in an array
  load_palette(input_file, pcx);

  fclose(input_file);                           // close PCX file
}

/*
 ͻ
                               Load PCX Image                              
 Ķ
                                                                           
   Description :  Decompress PCX image and store it in buffer.             
                                                                           
   Prototype   :  void pcx::load_image(FILE *pcx_file, pcx_class *pcx)     
                                                                           
 ͼ
*/

void pcx::load_image(FILE *pcx_file, pcx_class *pcx)
{

  int image_width, image_height, encoding = 0;
  long image_size;

  static unsigned char rle_byte_counter;
  static unsigned char run_byte_count;

  // calculate image size
  image_width=pcx->header.pcx_image_width-pcx->header.pcx_image_x_origin+1;
  image_height=pcx->header.pcx_image_height-pcx->header.pcx_image_y_origin+1;
  image_size = (long) image_width * image_height;

  // allocate memory for bitmap
  if ((pcx->pcx_image = new unsigned char[image_size]) == NULL) {
//    bail_out("Memory Allocation Failure", __LINE__);
    printf("Memory Allocation Failure\n");
    exit(1);
  }

  fseek(pcx_file, 128L, SEEK_SET);       	// reposition file pointer

  // loop for entire length of image_size
  for (register long image_count = 0; image_count < image_size; image_count++)
  {
    if (!encoding)  				// if byte run length only 1
    {
      // get next byte of image
      rle_byte_counter = (unsigned char) fgetc(pcx_file);

      if (rle_byte_counter > 191)     		// if run-length value
      {
	// get number of bytes in run-length
	run_byte_count = rle_byte_counter - 192;

	// get next byte of image
	rle_byte_counter = (unsigned char) getc(pcx_file);

	// if run-length value, set to decode run-length encoded image
	encoding = (--run_byte_count > 0) ? 1 : 0;
      }						// end if rle_byte_counter
    } 						// end if encoding

    // if not run-length value, set to decode single byte
    else encoding = (--run_byte_count < 1) ? 0 : 1;

    // get next byte of image
    pcx->pcx_image[image_count] = rle_byte_counter;
  }						// end for image_count
}

/*
 ͻ
                              Load PCX Palette                             
 Ķ
                                                                           
   Description :  Decompress PCX palette & store colour values in array.   
                                                                           
   Prototype   :  void pcx::load_palette(FILE *pcx_file, pcx_class *pcx)   
                                                                           
 ͼ
*/

void pcx::load_palette(FILE *pcx_file, pcx_class *pcx)
{
  // position file pointer 768 bytes from end of file
  fseek(pcx_file, -768L, SEEK_END);

  // read all 768 bytes of palette and adjust for bit shift
  for (register int count = 0; count < 768; count++)
      pcx->pcx_palette[count] = fgetc(pcx_file) >> 2;
}

/*
 ͻ
                               Source Code Ends                            
 ͼ
*/
